<?php
class AutoArticle_API {
    public function __construct() {}

    public function verify_membership($email, $password) {
        $url = AUTOARTICLE_API_URL . '?' . http_build_query(array(
            'action' => 'verify_membership',
            'email' => $email,
            'password' => $password,
            'external' => 1
        ));
        
        $response = wp_remote_get($url);

        if (is_wp_error($response)) {
            return false;
        }

        $body = wp_remote_retrieve_body($response);

        if (strpos($body, '<style>') !== false) {
            return false;
        }

        $decoded_body = json_decode($body, true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            return false;
        }

        if (isset($decoded_body['error'])) {
            return false;
        }

        return $decoded_body;
    }
    
    public function check_ip_limit() {
        $url = AUTOARTICLE_API_URL . '?' . http_build_query(array(
            'action' => 'check_ip_limit',
            'external' => 1
        ));
        
        $response = wp_remote_get($url, array('timeout' => 15));

        if (is_wp_error($response)) {
            return false;
        }

        $body = wp_remote_retrieve_body($response);

        if (strpos($body, '<style>') !== false) {
            return false;
        }

        $decoded_body = json_decode($body, true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            return false;
        }

        if (isset($decoded_body['error'])) {
            return false;
        }

        return $decoded_body;
    }

    /**
     * Get the latest number of articles remaining for a user
     * 
     * @param string $email User email
     * @param string $password User password
     * @return int Number of articles remaining or 0 on error
     */
    public function get_articles_remaining($email = '', $password = '') {
        if (!empty($email) && !empty($password)) {
            // Authenticated user flow
            $url = AUTOARTICLE_API_URL . '?' . http_build_query(array(
                'action' => 'get_articles_remaining',
                'email' => $email,
                'password' => $password,
                'external' => 1
            ));
        } else {
            // Anonymous user flow - check IP-based limit
            $url = AUTOARTICLE_API_URL . '?' . http_build_query(array(
                'action' => 'check_ip_limit',
                'external' => 1
            ));
        }
        
        $response = wp_remote_get($url, array('timeout' => 15));
        
        if (is_wp_error($response)) {
            return 0;
        }
        
        $body = wp_remote_retrieve_body($response);
        
        if (strpos($body, '<style>') !== false) {
            return 0;
        }
        
        $decoded_body = json_decode($body, true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            return 0;
        }
        
        if (isset($decoded_body['error'])) {
            return 0;
        }
        
        return isset($decoded_body['articles_remaining']) ? intval($decoded_body['articles_remaining']) : 0;
    }

    public function generate_article($params) {
        $request_params = [
            'external' => 1,
            'custom' => $params['custom'],
            'style' => $params['style'],
            'image_style' => $params['image_style'],
            'image_size' => $params['image_size'] ?? 'square',
            'language' => $params['language'] ?? 'en',
            'topic_usage' => $params['topic_usage'] ?? 'exact_match',
            'custom_writing_prompt' => $params['custom_writing_prompt'] ?? '',
            'custom_image_prompt' => $params['custom_image_prompt'] ?? ''
        ];

        // Determine authentication method
        if (!empty($params['server_auth_key']) && !empty($params['user_id_for_cron'])) {
            // Server-to-server authentication for cron jobs
            $request_params['server_auth_key'] = $params['server_auth_key'];
            $request_params['user_id_for_cron'] = $params['user_id_for_cron'];
        } elseif (!empty($params['email']) && !empty($params['password'])) {
            // Email/password authentication for external plugins
            $request_params['email'] = $params['email'];
            $request_params['password'] = $params['password'];
        }
        
        $response = wp_remote_post(AUTOARTICLE_API_URL, [
            'timeout' => 300, // Increased to 5 minutes for GPT-5 reasoning
            'body' => $request_params
        ]);

        if (is_wp_error($response)) {
             return $response; 
        }

        $body = wp_remote_retrieve_body($response);

        if (strpos($body, '<style>') !== false) {
            return false;
        }

        $decoded_body = json_decode($body, true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            return false;
        }

        return $decoded_body;
    }
} 